/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.logistics.depot;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.client.content.kinetics.base.ShaftRenderer;
import com.zurrtum.create.client.content.logistics.depot.DepotRenderer;
import com.zurrtum.create.client.flywheel.lib.transform.Rotate;
import com.zurrtum.create.client.flywheel.lib.transform.Translate;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.logistics.depot.DepotBehaviour;
import com.zurrtum.create.content.logistics.depot.EjectorBlock;
import com.zurrtum.create.content.logistics.depot.EjectorBlockEntity;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10442;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_12075;
import net.minecraft.class_12249;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5614;
import net.minecraft.class_761;
import net.minecraft.class_7833;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

@Environment(value=EnvType.CLIENT)
public class EjectorRenderer
extends ShaftRenderer<EjectorBlockEntity, EjectorRenderState> {
    static final class_243 pivot = VecHelper.voxelSpace(0.0, 11.25, 0.75);
    protected final class_10442 itemModelManager;

    public EjectorRenderer(class_5614.class_5615 context) {
        super(context);
        this.itemModelManager = context.comp_4536();
    }

    @Override
    public EjectorRenderState createRenderState() {
        return new EjectorRenderState();
    }

    @Override
    public void extractRenderState(EjectorBlockEntity be, EjectorRenderState state, float tickProgress, class_243 cameraPos, @Nullable class_11683.class_11792 crumblingOverlay) {
        DepotBehaviour behaviour;
        super.extractRenderState(be, state, tickProgress, cameraPos, crumblingOverlay);
        class_2680 blockState = be.method_11010();
        if (!state.support) {
            state.top = CachedBuffers.partial(AllPartialModels.EJECTOR_TOP, blockState);
            state.lidAngle = (float)Math.PI / 180 * (be.getLidProgress(tickProgress) * -70.0f);
            state.yRot = (float)Math.PI / 180 * (180.0f + AngleHelper.horizontalAngle((class_2350)blockState.method_11654((class_2769)EjectorBlock.HORIZONTAL_FACING)));
        }
        if ((behaviour = be.getBehaviour(DepotBehaviour.TYPE)) == null || behaviour.isEmpty()) {
            return;
        }
        class_1937 world = be.method_10997();
        state.incoming = DepotRenderer.createIncomingStateList(behaviour, this.itemModelManager, tickProgress, world);
        state.outputs = DepotRenderer.createOutputStateList(behaviour, this.itemModelManager, world);
        if (state.support && (state.incoming != null || state.outputs != null)) {
            state.field_62673 = be.method_11016();
            state.field_62675 = be.method_11017();
            state.field_62676 = world != null ? class_761.method_23794((class_1920)world, (class_2338)state.field_62673) : 0xF000F0;
            state.lidAngle = (float)Math.PI / 180 * (be.getLidProgress(tickProgress) * -70.0f);
            state.yRot = (float)Math.PI / 180 * (180.0f + AngleHelper.horizontalAngle((class_2350)blockState.method_11654((class_2769)EjectorBlock.HORIZONTAL_FACING)));
        }
    }

    @Override
    public void submit(EjectorRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        super.submit(state, matrices, queue, cameraState);
        if (state.incoming != null || state.outputs != null) {
            matrices.method_46416(0.5f, 0.5f, 0.5f);
            matrices.method_22907((Quaternionfc)class_7833.field_40716.rotation(state.yRot));
            matrices.method_46416(-0.5f, -0.5f, -0.5f);
            matrices.method_22904(EjectorRenderer.pivot.field_1352, EjectorRenderer.pivot.field_1351, EjectorRenderer.pivot.field_1350);
            matrices.method_22907((Quaternionfc)class_7833.field_40714.rotation(state.lidAngle));
            matrices.method_22904(-EjectorRenderer.pivot.field_1352, -EjectorRenderer.pivot.field_1351, -EjectorRenderer.pivot.field_1350);
            matrices.method_46416(0.5f, 0.5f, 0.5f);
            matrices.method_22907((Quaternionfc)class_7833.field_40716.rotation(-state.yRot));
            matrices.method_46416(-0.5f, -0.5f, -0.5f);
            DepotRenderer.renderItemsOf(state.incoming, state.outputs, state.field_62673, cameraState.field_63078, queue, matrices, state.field_62676);
        }
    }

    @Override
    protected class_1921 getRenderType(EjectorBlockEntity be, class_2680 state) {
        return class_12249.method_75965();
    }

    public boolean method_3563() {
        return true;
    }

    static <T extends Translate<T> & Rotate<T>> void applyLidAngle(KineticBlockEntity be, float angle, T tr) {
        ((Translate)((Rotate)((Translate)((Rotate)tr.center()).rotateYDegrees(180.0f + AngleHelper.horizontalAngle((class_2350)be.method_11010().method_11654((class_2769)EjectorBlock.HORIZONTAL_FACING)))).uncenter().translate(pivot)).rotateXDegrees(-angle)).translateBack(pivot);
    }

    @Environment(value=EnvType.CLIENT)
    public static class EjectorRenderState
    extends KineticBlockEntityRenderer.KineticRenderState {
        public SuperByteBuffer top;
        public float lidAngle;
        public float yRot;
        public DepotRenderer.DepotItemState[] incoming;
        public List<DepotRenderer.DepotOutputItemState> outputs;

        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            super.render(matricesEntry, vertexConsumer);
            ((SuperByteBuffer)((SuperByteBuffer)this.top.center()).rotateY(this.yRot)).uncenter();
            ((SuperByteBuffer)((SuperByteBuffer)this.top.translate(pivot)).rotateX(this.lidAngle)).translateBack(pivot);
            this.top.light(this.field_62676);
            this.top.renderInto(matricesEntry, vertexConsumer);
        }
    }
}

